# REPOLib
[![GitHub](https://img.shields.io/badge/GitHub-REPOLib-brightgreen?style=for-the-badge&logo=GitHub)](https://github.com/ZehsTeam/REPOLib)
[![Thunderstore Version](https://img.shields.io/thunderstore/v/Zehs/REPOLib?style=for-the-badge&logo=thunderstore&logoColor=white)](https://thunderstore.io/c/repo/p/Zehs/REPOLib/)
[![Thunderstore Downloads](https://img.shields.io/thunderstore/dt/Zehs/REPOLib?style=for-the-badge&logo=thunderstore&logoColor=white)](https://thunderstore.io/c/repo/p/Zehs/REPOLib/)
[![NuGet Version](https://img.shields.io/nuget/v/zehs.repolib?style=for-the-badge&logo=nuget)](https://www.nuget.org/packages/Zehs.REPOLib)

**Library for adding content to R.E.P.O.**

## Features
- **Registering network prefabs.**
- **Registering valuables.**
- **Registering items.**
- **Registering upgrades.**
- **Registering enemies.**
- **Registering levels.**
- ResourcesHelper to help get network prefab IDs.
- Method to spawn network prefabs. (Which works in both multiplayer and singleplayer)
- Methods to get valuables and spawn valuables.
- Methods to get items and spawn items.
- Methods to get enemies and spawn enemies.
- Registering custom chat /commands
    - Built-in dev mode commands: `Spawn Valuable`, `Spawn Item`, `Spawn Enemy`
- **Fixing audio mixer groups.**
- Making networked events.
- **Registering features without code using the [REPOLib-Sdk](https://github.com/ZehsTeam/REPOLib-Sdk).**

## Documentation
Documentation is available on the [R.E.P.O. Modding Wiki](https://repomods.com/repolib/overview.html).

## Developer Contact
**Report bugs, suggest features, or provide feedback:**

| **Discord Server** | **Forum** | **Post** |  
|--------------------|-----------|----------|  
| [R.E.P.O. Modding Server](https://discord.com/invite/vPJtKhYAFe) | `#released-mods` | [REPOLib](https://discord.com/channels/1344557689979670578/1346055794533339217) |

- **GitHub Issues Page:** [REPOLib](https://github.com/ZehsTeam/REPOLib/issues)
- **My Links:** https://solo.to/crithaxxog

[![kofi](https://i.imgur.com/jzwECeF.png)](https://ko-fi.com/zehsteam)
